*********************************************************************************
3/16/11:  RE-RAN AFTER ADDING PAWVAL AND TOT_TRANS
1/10/08: ADDED HH DATA FROM DATA FERRET BECAUSE THE DATA FROM THE CENSUS IS 
INCOMPLETE
*********************************************************************************;
 
options invaliddata="." notes fullstimer;
data hhold;
INFILE 'C:\Users\jsulliv4\Documents\CPSdata\2004_data\sullivan.197fb880x3h1.asc' lrecl=84;
INPUT
 @1 H_IDNUM $15.
 @17 HFDVAL 10.
 @28 HFOODMO 10.
 @39 HFOODNO 10.
 @50 HFOODSP 10.
 @61 HOUSRET 10.
 @72 HSEQ 10.
;
Label 
H_IDNUM = ''
HFDVAL = 'Food stamps amount - Household'
HFOODMO = 'Food stamps, number of months covered - Household'
HFOODNO = 'Food stamps, number of people covered - Household'
HFOODSP = 'Food stamps recipients Y/N - Household'
HOUSRET = 'Estimated home equity - Household'
HSEQ = 'Household sequence number on household record'
;
run;
PROC MEANS;
RUN;


   filename mar04 'C:\Users\jsulliv4\Documents\CPSdata\2004_data\04090-0001-Data.txt';
   filename mar04h 'C:\Users\jsulliv4\Documents\CPSdata\2004_data\hhext04.dat';
   filename mar04f 'C:\Users\jsulliv4\Documents\CPSdata\2004_data\ffext04.dat';
   filename mar04p 'C:\Users\jsulliv4\Documents\CPSdata\2004_data\ppext04.dat';  
           options obs=max mprint;

data cpsdata.all2004;
               infile mar04 missover lrecl=1000;

                  hhid=_n_;
                  input rectype  1 @;
                  if rectype=1 then input
                     state2      40-41
			   hseq      2-6
			   hlivqrt   31-32
			   htenure   35
			   htele     36
			   hreg 	 39
			   hmsasz    55
			   hpublic   74
			   hlorent   75
 			   hengval   86-89
			   htotval   248-255
 
                 @;
                  retain state2 
			hseq hlivqrt htenure htele hreg  hmsasz hpublic hlorent htotval   
			hengval;
                  if rectype=2 then input
                  famid 2-8
                  fkind 9
                  ftype 10
                  fpersons 11-12
                  fownu18 27
                  frelu18 29
                  fpovcut 32-36
                  famlis  37
                  ftotval  205-212
				  ftotearn  213-220

				  fpawval  103-108

					ffrval  64-70
					fseval  56-62
					fsurval  118-124
					foival  198-204
				 
                @;
               	retain  famid fpersons fkind ftype fownu18 frelu18 
			fpovcut ftotval famlis ftotearn fpawval
			ffrval fseval fsurval foival;

                  if rectype=3 then input
                      pseq       2-6
                      ppos   	   7-8
                       refrel2         13-14
                      age         15-16
                      marstat         17
                      sex         20
                      hga         22-23
                      race2           24-25
					  reorgn		  28
                     pertype         26
                      famrel          32
					  famrel2          35-36
                      msupwgt         66-73
                      rsnnotw         170
                      wkswrk          171-172
                      rsnnotl         179
                      hrswk           181-182
                      mainjob         228-233
                      source          234
                      wagesal1        824-829
                      selfemp1        830-835
                      ssi         819-823
                     pemlr           705
                      hrslw           76-77

					   ssinc           291-295
					   intinc          386-390
					   divinc          393-397
					   uiinc           278-282
					   wcinc		   285-289
					   pawval		   305-309
					   vetinc		   317-321
					   survinc		   337-342
					   retinc          379-384
					   alimony		   421-425	
					   ptotearn        448-455
					   ptotinc         440-447

                        ptotval 440-447
                       earnval 448-455

					   lfsr 145
					   citizen 733

					   sur_sc1	323-324
					   sur_sc2	325-326
					   sur_val1	327-331
					   sur_val2	332-336

					   wicyn 	900
					   mcaid	470
					   paidccyn	863

                  ;
if rectype^=3 then delete;
hgc=.;
run;

data cpsdata.all2004;
set cpsdata.all2004;

ipums_id=_N_;
run;


/*
DELETE BECAUSE THESE DATA ARE INCOMPLETE FOR HOUSRET
Data hhold;
           infile mar04h lrecl=50;
           input hseq 2-6 hfdval 9-12 housret 13-17;
run;			   
*/
Data fam;
           infile mar04f lrecl=50;
           input famid 2-8 
                  fmvfs 9-12
                  fhoussub 35-37    
                  fmvrsl 13-16    
                  fngmcare 22-26    
                  fngmcaid 17-21   ;
run;			   
Data pers;
           infile mar04p lrecl=70;
           input    pseq       2-6
                      ppos   	   7-8
                      pcapgain   14-18
                      pcaploss   19-22    
                      fedtax 38-42
                       statetax 61-65
                       fica 43-47
                      eitc 25-28
						emcontrb 29-32;
run;			   


* Bring in noncash benefit and aftertax income data;

proc sort data=cpsdata.all2004;
by hseq;
run;
proc sort data=hhold;
by hseq;
run;
data cpsdata.all2004;
merge cpsdata.all2004(in=in1) hhold;
by hseq;
if in1;
run;

proc sort data=cpsdata.all2004;
by famid;
run;
proc sort data=fam;
by famid;
run;
data cpsdata.all2004;
merge cpsdata.all2004(in=in1) fam;
by famid;
if in1;
run;

proc sort data=cpsdata.all2004;
by pseq ppos;
run;
proc sort data=pers;
by pseq ppos;
run;
data cpsdata.all2004;
merge cpsdata.all2004(in=in1) pers;
by pseq ppos;
if in1;
year=2004;
ref_year=year-1;
tottax=fedtax+statetax+fica-eitc;

IF sur_sc1=5 THEN rr1=1;
	ELSE rr1=0;
IF sur_sc2=5 THEN rr2=1;
	ELSE rr2=0;
railroad=sur_val1*rr1+sur_val2*rr2;
ssinc_rr=ssinc+railroad;

tot_trans=ssinc+uiinc+wcinc+vetinc+pawval+ssi+railroad;

IF mcaid=1 THEN mcaid_yes=1;
   ELSE mcaid_yes=0;

IF 0 LE age LE 4 THEN kid_0_4=1;
   ELSE kid_0_4=0;

IF age=0 THEN infant=1;
   ELSE infant=0;

IF famrel IN (1,2) AND sex=2 THEN pot_wic_mom=1;
   ELSE pot_wic_mom=0;

IF wicyn=1 THEN num_wic=1;
   ELSE num_wic=0;

run;


proc sort data=cpsdata.all2004;
   by famid;
run;
proc means sum noprint data=cpsdata.all2004;
   by famid;
   var tottax fedtax statetax fica eitc pcapgain pcaploss emcontrb tot_trans ssinc_rr mcaid_yes kid_0_4 wkswrk infant pot_wic_mom pawval num_wic;
   output out=temp sum=ftottax ffedtax fstatetax ffica feitc fcapgain fcaploss femcontrb ftot_trans fssinc_rr
					   fmcaid fkid_0_4 fwkswrk finfant fpot_wic_mom fpawval fnum_wic;
run;

data cpsdata.all2004;
   merge cpsdata.all2004 
         temp (keep=famid ftottax ffedtax fstatetax ffica feitc fcapgain fcaploss femcontrb ftot_trans fssinc_rr
					fmcaid fkid_0_4 fwkswrk finfant fpot_wic_mom fpawval fnum_wic);
   by famid; 
run;


data temp;
   set cpsdata.all2004;
   by famid;
   if first.famid; 
run;
proc sort data=temp;
   by hseq;
run;
* exclude the related subfamilies because their values of the following are 
  already included in the values for the primary family;
proc means sum noprint data=temp;
   by hseq;
   where ftype NE 3;
   var fmvfs fhoussub fmvrsl fngmcare fngmcaid ftotearn fpersons frelu18;
   output out=temp1 sum=hmvfs hhoussub hmvrsl hngmcare hngmcaid htotearn hpersons hrelu18;
run;
proc sort data=cpsdata.all2004;
   by hseq;
run;
proc means sum noprint data=cpsdata.all2004;
   by hseq;
   var tottax fedtax statetax fica eitc pcapgain pcaploss emcontrb tot_trans ssinc_rr;
   output out=temp sum=htottax hfedtax hstatetax hfica heitc hcapgain hcaploss hemcontrb htot_trans hssinc_rr;
run;

data cpsdata.all2004;
   merge cpsdata.all2004 
         temp (keep= hseq htottax hfedtax hstatetax hfica heitc hcapgain hcaploss hemcontrb htot_trans hssinc_rr)
		 temp1 (keep=hseq hmvfs hhoussub hmvrsl hngmcare hngmcaid htotearn hpersons hrelu18);
   by hseq; 
run;

proc means data=cpsdata.all2004;
run;

proc compare base=cpsdata.all2004_bak
             compare=cpsdata.all2004
			 novalues;
run;
